% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r5r_gui_demo.R
\name{r5r_gui_demo}
\alias{r5r_gui_demo}
\title{Run a Demonstration of the r5rgui Application}
\usage{
r5r_gui_demo(mode = c("WALK", "TRANSIT"))
}
\arguments{
\item{mode}{A character vector specifying the initial transport modes. Defaults to \code{c("WALK", "TRANSIT")}.}
}
\value{
This function does not return a value; it launches a Shiny application.
}
\description{
A simple wrapper function to launch the \code{r5rgui} Shiny application using
the sample Porto Alegre dataset included with the \code{r5r} package.

This function is designed for ease of use and demonstration purposes. It
automatically handles the setup of the \code{r5r_network} object and provides
default map settings (center and zoom) appropriate for the sample data.
}
\details{
The function first locates the sample data within the \code{r5r} package, then
calls \code{r5r::setup_r5()} to build the routing core. Finally, it launches
the Shiny app by calling \code{r5r_gui()} with these pre-configured objects.
Please note that \code{r5r} may need to download the sample data on first use,
which requires an internet connection.
}
\examples{
if (interactive()) {
  # To run the demo application, simply call the function:
  r5r_gui_demo()

  # Run with specific transport modes
  r5r_gui_demo(mode = c("WALK", "BUS"))
}

}
