% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imbalance_test.R
\name{imbalance_test}
\alias{imbalance_test}
\title{Test the imbalance of randomisation via simulation}
\usage{
imbalance_test(
  data,
  randovar,
  n_iter = 1000,
  stratavars = NULL,
  arms = NULL,
  cross = TRUE,
  ...
)
}
\arguments{
\item{data}{a dataframe with the variables indicated in \code{randovar} and,
optionally, \code{stratavars}}

\item{randovar}{character with the variable name indicating the randomisation}

\item{n_iter}{integer. number of simulations to perform}

\item{stratavars}{character vector with the variable names indicating the
stratification variables}

\item{arms}{character vector of arms in the appropriate balance. If NULL the
levels in \code{randovar} are used and assumed to be balanced}

\item{cross}{logical. Whether to cross the stratification variables.}

\item{...}{other arguments passed onto other methods}
}
\value{
a list with:
\itemize{
\item \code{n_rando}: the number of randomisations
\item \code{stratavars}: the names of the stratification variables
\item \code{arms}: the arms
\item \code{observed}: a dataframe with the observed imbalance
\item \code{simulated}: a dataframe with the simulated imbalances (number of rows = \code{nrow(n_iter)})
\item \code{tests}: a dataframe with the p-values
}
}
\description{
This function tests whether the observed imbalance is less than might be
expected via a random draw, via a permutation test.
}
\examples{
data(rando_balance)
# without stratification variables
imbalance_test(rando_balance, "rando_res", n_iter = 50)
imb <- imbalance_test(rando_balance, "rando_res", stratavars = "strat1", n_iter = 50)
imbalance_test(rando_balance, "rando_res", stratavars = c("strat1", "strat2"), n_iter = 50)
imb <- imbalance_test(rando_balance, "rando_res2", stratavars = c("strat1", "strat2"), n_iter = 50)
}
\seealso{
\code{\link[=imbalance_test_plot]{imbalance_test_plot()}}
}
