% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy-checksums.R
\name{Checksums}
\alias{Checksums}
\alias{get_checksums_value}
\alias{get_checksums_data}
\alias{update_checksums_value}
\alias{update_checksums_data}
\alias{read_checksums_value}
\alias{write_checksums_value}
\title{Load and store Checksums data}
\usage{
get_checksums_value(x, z, dimension, db = default_db())

get_checksums_data(x, z, dimension, db = default_db())

update_checksums_value(x, z, dimension, db = default_db())

update_checksums_data(x, z, dimension, db = default_db())

read_checksums_value(rawvalue, key)

write_checksums_value(value)
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{rawvalue}{A raw vector.}

\item{key}{A key prefix.}

\item{value}{A Checksums value.}
}
\value{
\code{get_checksums_value()} returns a Checksums value.
\code{get_checksums_data()} returns a named list of Checksums values.
Checksums values are named character vectors.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

Checksums data (tag 59) holds checksums for several chunk records.
These records are 2DMaps (tag 45), SubchunkBlocks (tag 47),
BlockEntities (tag 49), and Entities (tag 50). Checksums are no longer
used by the game.
\itemize{
\item \code{get_checksums_value()} and \code{get_checksums_data()} load Checksums
data from \code{db}. \code{get_checksums_value()} loads data for a single chunk,
and \code{get_checksums_data()} loads data for multiple chunks.
\item \code{update_checksums_value()} and \code{updates_checksums_data()}
recalculate Checksums data from \code{db} and update \code{db}.
\item \code{write_checksums_value()} encodes Checksums data into a raw vector.
\code{read_checksums_value()} decodes binary Checksums data.
}
}
\keyword{internal}
