% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-chunk.R
\name{ChunkData}
\alias{ChunkData}
\alias{get_chunk_value}
\alias{get_chunk_data}
\alias{put_chunk_value}
\alias{put_chunk_data}
\title{Load and store raw chunk data}
\usage{
get_chunk_value(x, z, dimension, tag, subtag, db)

get_chunk_data(x, z, dimension, tag, subtag, db)

put_chunk_value(value, x, z, dimension, tag, subtag, db)

put_chunk_data(values, x, z, dimension, tag, subtag, db)
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{value}{A raw vector.}

\item{values}{A list of raw vectors.}
}
\value{
\code{get_chunk_value()} returns a single raw vector.
\code{get_chunk_data()} returns a named list of raw data.
}
\description{
\itemize{
\item \code{get_chunk_value()} and \code{get_chunk_data()} load raw chunk data
from \code{db}. \code{get_chunk_value()} loads data for a single chunk,
and \code{get_chunk_data()} loads data for multiple chunks.
\item \code{put_chunk_value()} and \code{put_chunk_data()} store chunk
data for one or multiple chunks into \code{db}.
}
}
\keyword{internal}
