% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc.R
\name{split_dim}
\alias{split_dim}
\title{Transform array into list of arrays}
\usage{
split_dim(a, n)
}
\arguments{
\item{a}{Array with number of dimensions at least 2.}

\item{n}{Positive integer. Dimension of \code{a} to be listed.}
}
\value{
A list of length \code{n} of arrays with number of dimensions equal to the
number of dimensions of \code{a} minus 1.
}
\description{
Transform an array into list of arrays where the listing
is performed on a given dimension.
}
\details{
For example, if \code{a} is a 3 dimensional array and \code{n = 1},
\code{split_dim(a,n)} returns a list of 2 dimensional arrays (i.e.
a list of matrices) where each element of the list is \code{a[i, , ]}, where
\code{i} takes values from 1 to the length of the first dimension of the array.

Example:

inputs:
\code{a <- array( c(1,2,3,4,5,6,7,8,9,10,11,12), dim = c(3,2,2))},
which means that:

\if{html}{\out{<div class="sourceCode">}}\preformatted{a[1,,]     a[2,,]     a[3,,]

[,1] [,2]  [,1] [,2]  [,1] [,2]
---------  ---------  ---------
 1    7     2    8     3    9
 4    10    5    11    6    12
}\if{html}{\out{</div>}}

\code{n <- 1}

output of \code{res <- split_dim(a,n)} is a list of 3 elements:

\if{html}{\out{<div class="sourceCode">}}\preformatted{res[[1]]   res[[2]]   res[[3]]

[,1] [,2]  [,1] [,2]  [,1] [,2]
---------  ---------  ---------
 1    7     2    8     3    9
 4    10    5    11    6    12
}\if{html}{\out{</div>}}
}
