% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hiredis.R
\name{hiredis}
\alias{hiredis}
\alias{redis_available}
\title{Interface to Redis}
\usage{
hiredis(..., version = NULL)

redis_available(...)
}
\arguments{
\item{...}{Named configuration options passed to \code{\link[=redis_config]{redis_config()}},
used to create the environment (notable keys include \code{host},
\code{port}, and the environment variable \code{REDIS_URL}).  For
\code{redis_available()}, arguments are passed through to \code{hiredis}.}

\item{version}{Version of the interface to generate.  If given as
a string to numeric version, then only commands that exist up to
that version will be included.  If given as \code{TRUE}, then we will
query the Redis server (with \code{INFO}) and extract the version
number that way.}
}
\description{
Create an interface to Redis, with a generated interface to all
Redis commands.
}
\details{
There is no need to explicitly close the redis connection.  It
will be closed automatically when the connection goes out of scope
and is garbage collected.
}
\section{Arbitrary commands with \code{command()}}{
##' Redis releases new commands frequently, or it's possible that the
wrapper created by redux is too inflexible for your use case.  In
this situation you can use the \code{command()} method to send
arbitrary commands to the server and either use these unsupported
commands, or fundamentally change how they work.

See \code{\link[=redis_connection]{redis_connection()}} for details on how to use this.
}

\section{Warning}{
Some commands will block.  This includes \code{BRPOP} (and other
list commands beginning with \code{B}).  Once these commands have
been started, they cannot be interrupted by Ctrl-C from an R
session.  This is because the \code{redux} package hands over
control to a blocking function in the \code{hiredis} (C) library,
and this cannot use R's normal interrupt machinery.  If you want
to block but retain the ability to interrupt then you will need to
wrap this in another call that blocks for a shorter period of
time:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{  found <- NULL
  con <- redux::hiredis()
  found <- NULL
  while (is.null(found)) \{
    found <- con$BLPOP("key", 1)
    Sys.sleep(0.01) # needed for R to notice that interrupt has happened
  \}
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (redux::redis_available()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
r <- redux::hiredis()
r$PING()
r$SET("foo", "bar")
r$GET("foo")

# There are lots of methods here:
r
\dontshow{\}) # examplesIf}
}
