% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{getRelative}
\alias{getRelative}
\alias{makeRelative}
\title{Relative paths}
\usage{
getRelative(path, relativeToPath)

makeRelative(files, absoluteBase)
}
\arguments{
\item{path}{character vector or list specifying file paths}

\item{relativeToPath}{directory against which \code{path} will be relativized.}

\item{files}{character vector or list specifying file paths}

\item{absoluteBase}{base directory (as absolute path) to prepend to \code{files}}
}
\description{
Extracting relative file paths.
}
\details{
\itemize{
\item \code{getRelative()} searches \code{path} "from the right" (instead of "from the left")
and tries to reconstruct it relative to directory specified by \code{relativeToPath}.
This is useful when dealing with symlinked paths.
\item \code{makeRelative()} checks to see if \code{files} and \code{normPath(absoluteBase)} share a common path
(i.e., "from the left"), otherwise it returns \code{files}.
}
}
\examples{
\dontshow{if (!identical(.Platform$OS.type, "windows")) withAutoprint(\{ # examplesIf}

## create a project directory (e.g., on a hard drive)
(tmp1 <- tempdir2("myProject", create = TRUE))

## create a cache directory elsewhere (e.g., on an SSD)
(tmp2 <- tempdir2("my_cache", create = TRUE))

## symlink the project cache directory to tmp2
## files created here are actually stored in tmp2
prjCache <- file.path(tmp1, "cache")
file.symlink(tmp2, prjCache)

## create a dummy cache object file in the project cache dir
(tmpf <- tempfile("cache_", prjCache))
cat(rnorm(100), file = tmpf)
file.exists(tmpf)
normPath(tmpf) ## note the 'real' location (i.e., symlink resolved)

getRelative(tmpf, prjCache) ## relative path
getRelative(tmpf, tmp2) ## relative path

makeRelative(tmpf, tmp2) ## abs path; tmpf and normPath(tmp2) don't share common path
makeRelative(tmpf, prjCache) ## abs path; tmpf and normPath(tmp2) don't share common path
makeRelative(normPath(tmpf), prjCache) ## rel path; share common path when both normPath-ed

unlink(tmp1, recursive = TRUE)
unlink(tmp2, recursive = TRUE)
\dontshow{\}) # examplesIf}
}
