% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orbital_speed.R
\name{compute_orbital_speeds}
\alias{compute_orbital_speeds}
\title{Compute the orbital speed at a given depth from the wave elevation 1D spectra}
\usage{
compute_orbital_speeds(spec, freq, z = 0, depth = Inf, output_speeds = FALSE)
}
\arguments{
\item{spec}{1D spectral data: TxM matrix}

\item{freq}{the M frequencies}

\item{z}{distance above the floor at which we want the orbital speed (single numeric)}

\item{depth}{depth time series (vector length T. Recycled if a single value is given)}

\item{output_speeds}{TRUE if the spectral speed are needed. Otherwise, returns the RMS (default)}
}
\value{
depending on spec, a list with the spectral velocities for each component
(if output_speeds==FALSE) or a data.frame with a time series of horizontal and vertical
components of (spectral) orbital speed.
}
\description{
Compute the orbital speed at a given depth from the wave elevation 1D spectra
}
\examples{
# Compute orbital speed for varying Hs
S <- t(sapply(1:10, function(h) {
  jonswap(h)$spec
}))
orb_speeds <- compute_orbital_speeds(S, rscd_freq, depth = 100, z = 10)
plot(1:10, orb_speeds[, 1],
  type = "l",
  ylim = range(orb_speeds),
  xlab = "Hs (m)",
  ylab = "Orbital speed RMS (m/s)"
)
lines(1:10, orb_speeds[, 2], type = "l", col = "red")
}
