% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendars.R
\name{easter_day}
\alias{easter_day}
\title{Set a Holiday on an Easter related day}
\usage{
easter_day(offset, julian = FALSE, weight = 1, validity = NULL)
}
\arguments{
\item{offset}{The position of the holiday in relation to Easter Sunday, measured in days (can be positive or negative).}

\item{julian}{Boolean indicating if Julian calendar must be used.}

\item{weight}{weight associated to the holiday.}

\item{validity}{validity period: either \code{NULL} (full sample) or a named list
with \code{"start"} and/or "end" dates in the format \code{"YYYY-MM-DD"}.}
}
\value{
returns an object of class \code{c("JD3_EASTERDAY","JD3_HOLIDAY")}
}
\description{
Allows to define a holiday which date is related to Easter Sunday.
}
\examples{
\dontshow{if (current_java_version >= minimal_java_version) withAutoprint(\{ # examplesIf}
easter_day(1) # Easter Monday
easter_day(-2) # Easter Good Friday
# Corpus Christi 60 days after Easter
# Sunday in Julian calendar with weight 0.5, from January 2000 to December 2020
easter_day(
    offset = 60, julian = TRUE, weight = 0.5,
    validity = list(start = "2000-01-01", end = "2020-12-01")
)
\dontshow{\}) # examplesIf}
}
\references{
More information on calendar correction in JDemetra+ online documentation:
\url{https://jdemetra-new-documentation.netlify.app/a-calendar-correction}
}
\seealso{
\code{\link{national_calendar}}, \code{\link{fixed_day}},\code{\link{special_day}},\code{\link{fixed_week_day}}
}
