% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/store.R
\name{rdf_remove}
\alias{rdf_remove}
\title{Remove a Triple}
\usage{
rdf_remove(store, subject, predicate, object, graph = NULL)
}
\arguments{
\item{store}{An RDF store handle}

\item{subject}{Subject IRI or blank node}

\item{predicate}{Predicate IRI}

\item{object}{Object: IRI, blank node, or literal}

\item{graph}{Optional named graph IRI}
}
\value{
Invisibly returns NULL
}
\description{
Removes a single triple from the store.
}
\examples{
store <- rdf_store()
rdf_add(store, "<http://example.org/s>", "<http://example.org/p>", '"hello"')
rdf_remove(store, "<http://example.org/s>", "<http://example.org/p>", '"hello"')
rdf_size(store)
}
