% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration.R
\name{extract_coregistration}
\alias{extract_coregistration}
\title{Extract transform in right-anterior-superior coordinate system}
\usage{
extract_coregistration(transform_path, moving_img, outprefix = NULL)
}
\arguments{
\item{transform_path}{path to the transform
(\code{'ANTs_0GenericAffine.mat'} matrix) file}

\item{moving_img}{path to the moving image, for example, if \code{'CT'} is
aligned to \code{'T1w'}, then \code{'CT'} is the moving image}

\item{outprefix}{output prefix, where the matrices are saved to; default is
at the same folder as \code{transform_path}}
}
\value{
A list of two matrices: \code{new_sform} is the new index to image
transform (see \code{'sform'} in 'NIfTI' header definition). This is a
four-by-four matrix transforming from the voxel index (moving image) to the
fixed image \code{'RAS'} coordinates. \code{ras_transform} is a four-by-four
matrix from the moving image to the fixed image in \code{'RAS'} coordinates.
}
\description{
Extract transform from 'ANTs' and moving image, save the transform matrices.
}
