% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REPEATED_DDCt.r
\name{REPEATED_DDCt}
\alias{REPEATED_DDCt}
\title{Fold change (\eqn{\Delta\Delta C_T}) analysis of repeated-measure qPCR data}
\usage{
REPEATED_DDCt(
  x,
  numberOfrefGenes,
  factor,
  calibratorLevel,
  block,
  x.axis.labels.rename = "none",
  p.adj = "none",
  plot = TRUE,
  plotType = "RE"
)
}
\arguments{
\item{x}{A data frame in which the first column is the individual identifier (\code{id}),
followed by one or more factor columns (including \code{time}).
Expression-related columns (time, target gene, reference gene(s)) must appear
at the end of the data frame in the required order.}

\item{numberOfrefGenes}{Integer specifying the number of reference genes (must be \eqn{\ge 1}).}

\item{factor}{Character string specifying the factor for which fold changes are analysed
(commonly \code{"time"}).}

\item{calibratorLevel}{A level of \code{factor} to be used as the calibrator (reference level).}

\item{block}{Optional blocking factor column name. If supplied, block effects are treated
as random effects.}

\item{x.axis.labels.rename}{Optional character vector used to replace x-axis labels in the bar plot.}

\item{p.adj}{Method for p-value adjustment (passed to \code{emmeans}).}

\item{plot}{Logical; if \code{FALSE}, plots are not produced.}

\item{plotType}{Either \code{"RE"} (relative expression) or \code{"log2FC"} (log2 fold change).}
}
\value{
A list with the following components:
\describe{
  \item{Final_data}{Input data frame augmented with weighted \eqn{\Delta C_T} values.}
  \item{lm}{Fitted linear mixed-effects model object.}
  \item{ANOVA_table}{ANOVA table for fixed effects.}
  \item{Relative_Expression_table}{Table containing RE values, log2FC, p-values,
  significance codes, confidence intervals, and standard errors.}
  \item{RE_Plot}{Bar plot of relative expression values (if requested).}
  \item{log2FC_Plot}{Bar plot of log2 fold change values (if requested).}
}
}
\description{
The \code{REPEATED_DDCt} function performs fold change (FC) analysis using the
\eqn{\Delta\Delta C_T} method for qPCR data obtained from repeated measurements
over time. Data may originate from uni- or multi-factorial experimental designs.

In addition to numerical results, bar plots of relative expression (RE) or log2
fold change values with associated uncertainty are optionally produced.
}
\details{
The analysis is carried out using a linear mixed-effects model in which repeated
measurements are accounted for by a random effect of individual (\code{id}).
The factor of interest (e.g. time or treatment) is specified via the
\code{factor} argument. The first level of this factor (or the level specified
by \code{calibratorLevel}) is used as the calibrator.

The function supports one or more reference genes. When multiple reference genes
are supplied, their contributions are averaged when computing weighted
\eqn{\Delta C_T} values.
}
\examples{
REPEATED_DDCt(
  data_repeated_measure_1,
  numberOfrefGenes = 1,
  factor = "time",
  calibratorLevel = "1",
  block = NULL
)

REPEATED_DDCt(
  data_repeated_measure_2,
  numberOfrefGenes = 1,
  factor = "time",
  calibratorLevel = "1",
  block = NULL
)
}
\author{
Ghader Mirzaghaderi
}
