% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Schumaker.R
\name{impute_gradients}
\alias{impute_gradients}
\title{impute gradients from two vectors with x and y coordinates.}
\usage{
impute_gradients(x, y, edgeGradients = c(NA, NA))
}
\arguments{
\item{x}{A vector of x coordinates}

\item{y}{A corresponding vector of y coordinates}

\item{edgeGradients}{This gives the options of specifing the gradients at either edge of the domain. By default this is c(NA,NA) meaning that the defaults from the original paper are used. If this is set to c(0,NA) for instance this will mean that the left edge gradient is zero and the right edge gradient is as recommended in the original paper. This setting has no impact if a full set of gradients is input.}
}
\description{
impute gradients from two vectors with x and y coordinates.
}
\examples{
x = seq(1,6)
y = log(x)
grads = impute_gradients(x, y)
}
\references{
Schumaker, L.L. 1983. On shape-preserving quadratic spline interpolation. SIAM Journal of Numerical Analysis 20: 854-64.

Judd (1998). Numerical Methods in Economics. MIT Press
}
