% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_representation.R
\name{adj_CDF_logit}
\alias{adj_CDF_logit}
\alias{adj_CDF_logit.scppp}
\alias{adj_CDF_logit.matrix}
\title{A novel data representation based on Poisson probability}
\usage{
adj_CDF_logit(data, change = 1e-10, ...)

\method{adj_CDF_logit}{scppp}(data, change = 1e-10, ...)

\method{adj_CDF_logit}{matrix}(data, change = 1e-10, ...)
}
\arguments{
\item{data}{A UMI count data matrix with genes as rows and cells as columns or an S3 object for class 'scppp'.}

\item{change}{A numeric value used to correct for exactly 0 and 1 before logit transformation.
Any values below \code{change} are set to be \code{change} and
any values above \eqn{1- change} are set to be \eqn{1- change}.}

\item{...}{not used.}
}
\value{
A matrix of departure as a novel data representation (matrix as input) or an S3 object for class 'scppp' (scppp object as input; departure result will be stored in object scppp under "representation").
}
\description{
This function returns a matrix of a novel data representation with the same dimension as input data matrix.
}
\details{
This is a function used to calculate model departure as a novel data representation.
}
\examples{
# Matrix as input
test_set <- matrix(rpois(500, 0.5), nrow = 10)
adj_CDF_logit(test_set)
# scppp object as input
adj_CDF_logit(scppp(test_set))

}
