% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_ons_table.R
\name{get_ons_table}
\alias{get_ons_table}
\title{Get ONS data}
\usage{
get_ons_table(
  id,
  base_url = "https://www.nomisweb.co.uk/api/v01",
  csv_parser_fnc = utils::read.csv,
  ...
)
}
\arguments{
\item{id}{a table ID recognised by 'nomis' (e.g. "NM_1_1")}

\item{base_url}{Nomis base url to query. Default: "https:www.nomisweb.co.uk/api/v01"}

\item{csv_parser_fnc}{Function for parsing the csv file from Nomis API url. Default: read.csv}

\item{...}{Additional parameters used to filter and aggregate the data retrieved from ONS.
These are passed to build_url_query_string to build everything in the url after "?".
See "https://www.nomisweb.co.uk/api/v01/help for information on the options available}
}
\value{
A dataframe containing the data downloaded from ONS' Nomis API
}
\description{
Retrieve data from the Office of National Statistics (ONS) via the Nomis API for a
given dataset.
}
\examples{
# Pull all data from the "Jobseeker's Allowance" dataset
\dontrun{get_ons_table("nm_1_1")}
# Filter "Jobseeker's Allowance" dataset and select columns to output ('select')
get_ons_table("nm_1_1", geography = "TYPE480", time = "latest", measures = 20100, item = 1, 
              select = c("geography_name", "sex_name", "obs_value"))

# Aggregate statistics using 'rows' and 'cols'
get_ons_table("nm_1_1", 
              geography = "TYPE480", time = "latest", measures = 20100, item = 1, 
              select = c("geography_name", "sex_name", "obs_value"),
              rows = c("geography_name"), cols = c("sex_name"))

}
