% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.tif.R
\name{plot.tif}
\alias{plot.tif}
\title{Plot TIF}
\usage{
\method{plot}{tif}(x, ...)
}
\arguments{
\item{x}{object of class \code{tif} obtained with the \code{tif()} function}

\item{...}{other arguments}
}
\value{
A \code{ggplot} displaying the TIF
}
\description{
Plot TIF
}
\examples{
set.seed(123)
n <- 5
item_par <- data.frame(
  b = runif(n, -3, 3),
  a = runif(n, 1.2, 1.9),
  c = rep(0, n),
  e = rep(1, n)
)
iifs <- item_info(item_par)
test_tif <- tif(iifs)
plot(test_tif)
# compute the mean tif
test_tif_mean <- tif(iifs, fun = "mean")
plot(test_tif_mean)
}
