% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{TestPhi}
\alias{TestPhi}
\title{Test the Drift Matrix}
\usage{
TestPhi(phi, margin = 0, auto_ubound = 0)
}
\arguments{
\item{phi}{Numeric matrix.
The drift matrix (\eqn{\boldsymbol{\Phi}}).}

\item{margin}{Numeric scalar specifying the stability threshold
for the real part of the eigenvalues.
The default \code{0.0} corresponds to the imaginary axis;
values less than \code{0.0} enforce a stricter stability margin.}

\item{auto_ubound}{Numeric scalar specifying the upper bound
for the diagonal elements of \eqn{\boldsymbol{\Phi}}.
Default is \code{0.0}, requiring all diagonal values to be \eqn{\leq 0}.}
}
\description{
Both have to be true for the function to return \code{TRUE}.
\itemize{
\item Test that the real part of all eigenvalues of \eqn{\boldsymbol{\Phi}}
are less than zero.
\item Test that the diagonal values of \eqn{\boldsymbol{\Phi}}
are between 0 to negative inifinity.
}
}
\examples{
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
TestPhi(phi = phi)

}
\seealso{
Other Simulation of State Space Models Data Functions: 
\code{\link{LinSDE2SSM}()},
\code{\link{LinSDECovEta}()},
\code{\link{LinSDECovY}()},
\code{\link{LinSDEMeanEta}()},
\code{\link{LinSDEMeanY}()},
\code{\link{ProjectToHurwitz}()},
\code{\link{ProjectToStability}()},
\code{\link{SSMCovEta}()},
\code{\link{SSMCovY}()},
\code{\link{SSMMeanEta}()},
\code{\link{SSMMeanY}()},
\code{\link{SimAlphaN}()},
\code{\link{SimBetaN}()},
\code{\link{SimBetaN2}()},
\code{\link{SimBetaNCovariate}()},
\code{\link{SimCovDiagN}()},
\code{\link{SimCovN}()},
\code{\link{SimIotaN}()},
\code{\link{SimNuN}()},
\code{\link{SimPhiN}()},
\code{\link{SimPhiN2}()},
\code{\link{SimPhiNCovariate}()},
\code{\link{SimSSMFixed}()},
\code{\link{SimSSMIVary}()},
\code{\link{SimSSMLinGrowth}()},
\code{\link{SimSSMLinGrowthIVary}()},
\code{\link{SimSSMLinSDEFixed}()},
\code{\link{SimSSMLinSDEIVary}()},
\code{\link{SimSSMOUFixed}()},
\code{\link{SimSSMOUIVary}()},
\code{\link{SimSSMVARFixed}()},
\code{\link{SimSSMVARIVary}()},
\code{\link{SpectralRadius}()},
\code{\link{TestPhiHurwitz}()},
\code{\link{TestStability}()},
\code{\link{TestStationarity}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Simulation of State Space Models Data Functions}
\keyword{linsde}
\keyword{simStateSpace}
\keyword{test}
