% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importRaster.R
\name{importRaster}
\alias{importRaster}
\title{Import generic raster file}
\usage{
importRaster(
  file = file.choose(),
  k = 1,
  kz = 1,
  dx = 0,
  dy = 0,
  destaggering = FALSE,
  variable = NULL,
  verbose = FALSE
)
}
\arguments{
\item{file}{character. Path to the raster file.}

\item{k}{numeric. Factor applied to x and y coordinates (default = 1).
For example, it can be used to convert the grid coordinates from km
to m (k = 1000).}

\item{kz}{numeric. Factor applied to the variable values (default = 1).}

\item{dx, dy}{numeric. Constant to shift x and y coordinates (default = 0).}

\item{destaggering}{Use \code{TRUE} to apply destaggering to X and Y coordinates
(default = FALSE). See the \code{Details} section.}

\item{variable}{character. The name of the variable to be imported.}

\item{verbose}{logical. If \code{TRUE}, prints out basic statistics (default = FALSE).}
}
\value{
A data.frame with x, y and z columns for the grid cells coordinates
and the variable value.
}
\description{
A function to import the first layer of a generic raster file.
}
\details{
This function is based on the \pkg{terra} package and it can import any format
managed by it as NetCDF.

Destaggering applies a shift equal to half grid size in both horizontal
directions. It is useful for importing data from the SPRAY air quality dispersion
model and it is not applied by default.

An optional summary output can be printed out by setting the \code{verbose} parameter
to \code{TRUE}.
}
\examples{
\dontrun{
# Import binary (netcdf) file and convert coordinates from km to m,
# without destaggering. Variable name is "NOx".
mydata <- importRaster(
    file = "/path_to_file/filename.nc",
    variable = "NOx",
    k = 1000,
    destaggering = FALSE
)

# Import binary (netcdf) file and convert coordinates from km to m,
# with shift of 100 m in both directions:
mydata <- importRaster(
    file = "/path_to_file/filename.nc",
    variable = "pm10",
    k = 1000,
    dx = 100,
    dy = 100
)
}
}
\seealso{
\code{\link[=importADSOBIN]{importADSOBIN()}}, \code{\link[=importSurferGrd]{importSurferGrd()}}
}
