% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_get_probs.R
\name{sits_get_probs}
\alias{sits_get_probs}
\alias{sits_get_probs.csv}
\alias{sits_get_probs.shp}
\alias{sits_get_probs.sf}
\alias{sits_get_probs.sits}
\alias{sits_get_probs.data.frame}
\alias{sits_get_probs.default}
\title{Get values from probability maps}
\usage{
sits_get_probs(cube, samples, window_size = NULL)

\method{sits_get_probs}{csv}(cube, samples, window_size = NULL)

\method{sits_get_probs}{shp}(cube, samples, window_size = NULL)

\method{sits_get_probs}{sf}(cube, samples, window_size = NULL)

\method{sits_get_probs}{sits}(cube, samples, window_size = NULL)

\method{sits_get_probs}{data.frame}(cube, samples, window_size = NULL)

\method{sits_get_probs}{default}(cube, samples, window_size = NULL)
}
\arguments{
\item{cube}{Probability data cube.}

\item{samples}{Location of the samples to be retrieved.
Either a tibble of class "sits",
an "sf" object with POINT geometry,
the location of a POINT shapefile,
the location of csv file  with columns
"longitude" and "latitude", or
a data.frame with columns "longitude" and "latitude"}

\item{window_size}{Size of window around pixel (optional)}
}
\value{
A tibble of with columns
                       <longitude, latitude, values> in case no windows
                       are requested and <longitude, latitude, neighbors>
                       in case windows are requested
}
\description{
Given a set of lat/long locations and a probability cube,
retrieve the prob values of each point. This function is useful
to estimate probability distributions and to assess the differences
between classifiers.
}
\note{
There are four ways of specifying data to be retrieved using the
\code{samples} parameter:
\itemize{
\item{CSV: a CSV file with columns \code{longitude}, \code{latitude}.}
\item{SHP: a shapefile in POINT geometry.}
\item{sf object:  An \code{link[sf]{sf}} object with POINT geometry.}
\item{sits object: A valid tibble with \code{sits} timeseries.}
\item{data.frame: A data.frame with \code{longitude} and \code{latitude}.}
}
}
\examples{
if (sits_run_examples()) {
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # obtain the a set of points for sampling
    ground_truth <- system.file("extdata/samples/samples_sinop_crop.csv",
        package = "sits"
    )
    # get the classification values for a selected set of locations
    probs_samples <- sits_get_probs(probs_cube, ground_truth)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
