% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statLearn.R
\name{ROCcurve}
\alias{ROCcurve}
\title{Plot the ROC curve}
\usage{
ROCcurve(mod, nw = NULL)
}
\arguments{
\item{mod}{A logistic regression, LDA, or QDA model}

\item{nw}{A dataset for which a testing ROC curve should be plotted 
using the model in \code{mod}. Note that it must contain the predictors as
well as the responses. If this argument is NULL (the default) the training
ROC curve will be plotted.}
}
\value{
A plot with the ROC curve will be produced, nothing is returned.
}
\description{
Plot the ROC curve for logistic regression, LDA, or QDA models.
}
\examples{
gmod=glm(state~.,binomial,Puromycin)
ROCcurve(gmod)
}
