% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pitch_postprocessing.R
\name{findVoicedSegments}
\alias{findVoicedSegments}
\title{Find voiced segments}
\usage{
findVoicedSegments(
  pitchCands,
  shortestSyl,
  shortestPause,
  step,
  minVoicedCands,
  pitchMethods,
  manualV = NULL,
  manualTryToV = NULL,
  manualUnv = NULL
)
}
\arguments{
\item{pitchCands}{matrix of possible pitch values per column. One column is
one fft frame, one row is one pitch candidate}

\item{shortestSyl}{the smallest length of a voiced segment (ms) that
constitutes a voiced syllable (shorter segments will be replaced by NA, as
if voiceless)}

\item{shortestPause}{the smallest gap between voiced syllables (ms): large
value = interpolate and merge, small value = treat as separate syllables
separated by a voiceless gap}

\item{step}{you can override \code{overlap} by specifying FFT step, ms - a
vector of the same length as windowLength (NB: because digital audio is
sampled at discrete time intervals of 1/samplingRate, the actual step and
thus the time stamps of STFT frames may be slightly different, eg 24.98866
instead of 25.0 ms)}

\item{minVoicedCands}{a frame is considered to be voiced if at least this
many pitch candidates are not NA. Defaults to 2: since dom is usually
defined, in practice this means that we also want at least one other pitch
candidate (autocor, cep or BaNa)}

\item{pitchMethods}{methods of pitch tracking in analyze()}

\item{manualV}{index of frames that should definitely be voiced (manual
candidates)}

\item{manualTryToV}{index of frames that should be treated as voiced as long
as they have any candidates at all (even <minVoicedCands)}

\item{manualUnv}{index of frames forced to be unvoiced}
}
\value{
Returns a dataframe specifying where each voiced segment starts and
  ends (in fft frames, not ms!)
}
\description{
Internal soundgen function.
}
\details{
Internal helper function for postprocessing of pitch contours. Merges voiced
segments at least \code{shortestSyl} ms long and separated by less than
\code{shortestPause} ms. Called by \code{\link{analyze}}
}
\examples{
pitch = c(rep(NA, 5), rnorm(15, 300, 15), rep(NA, 7), rnorm(10, 400, 10), rep(NA, 6))
plot(pitch, type = 'b')
soundgen:::findVoicedSegments(
  pitchCands = matrix(pitch, nr = 1),
  shortestSyl = 20,
  shortestPause = 60,
  step = 10,
  minVoicedCands = 1,
  pitchMethods = 'blabla',
  manualV = NULL,
  manualTryToV = NULL,
  manualUnv = NULL
)
}
\keyword{internal}
