% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surfaceplot.R
\name{surfaceplot2}
\alias{surfaceplot2}
\title{Make two side-by-side surface plots}
\usage{
surfaceplot2(
  tab,
  coords_name,
  var1_name,
  var2_name,
  h = 8,
  col.pal,
  mark_points = FALSE
)
}
\arguments{
\item{tab}{a data-frame containing spatial co-ordinates and the variables to
plot}

\item{coords_name}{name of the two columns that contains the co-ordinates of
the points}

\item{var1_name}{name of the column containing the first variable to be
plotted}

\item{var2_name}{name of the column containing the second variable to be
plotted}

\item{h}{integer; (optional) controls smoothness of the spatial interpolation
as appearing in the \code{\link[MBA:mba.surf]{MBA::mba.surf()}} function. Default is 8.}

\item{col.pal}{Optional; color palette, preferably divergent, use
\code{colorRampPalette} function from \code{grDevices}. Default is 'RdYlBu'.}

\item{mark_points}{Logical; if \code{TRUE}, the input points are marked.
Default is \code{FALSE}.}
}
\value{
a list containing two \code{ggplot} objects
}
\description{
Make two side-by-side surface plots, particularly useful towards
a comparative study of two spatial surfaces.
}
\examples{
data(simGaussian)
plots_2 <- surfaceplot2(simGaussian, coords_name = c("s1", "s2"),
                        var1_name = "z_true", var2_name = "y")
plots_2
}
\author{
Soumyakanti Pan \href{mailto:span18@ucla.edu}{span18@ucla.edu},\cr
Sudipto Banerjee \href{mailto:sudipto@ucla.edu}{sudipto@ucla.edu}
}
