% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.agree2}
\alias{ci.agree2}
\title{Confidence interval for G-index difference in a 2-group design}
\usage{
ci.agree2(alpha, n1, f1, n2, f2, k)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{n1}{sample size (objects) in group 1}

\item{f1}{number of objects rated in agreement in group 1}

\item{n2}{sample size (objects) in group 2}

\item{f2}{number of objects rated in agreement in group 2}

\item{k}{number of rating categories}
}
\value{
Returns a 3-row matrix. The rows are:
\itemize{
\item Row 1: G-index for group 1
\item Row 2: G-index for group 2
\item Row 3: G-index difference
}

The columns are:
\itemize{
\item Estimate - maximum likelihood estimate of G-index and difference
\item SE - standard error
\item LL - lower limit of adjusted Wald confidence interval
\item UL - upper limit of adjusted Wald confidence interval
}
}
\description{
Computes adjusted Wald confidence intervals for the G-index of agreement
within each group and the difference of G-indices.

For more details, see Section 3.5 of Bonett (2021, Volume 3)
}
\examples{
ci.agree2(.05, 75, 70, 60, 45, 2)

# Should return:
#         Estimate      SE     LL     UL
# G1        0.8667 0.02880 0.6975 0.9481
# G2        0.5000 0.05590 0.2523 0.6852
# G1 - G2   0.3667 0.06289 0.1117 0.6089               


}
\references{
\insertRef{Bonett2022}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
