% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.ci.lc.stdmean.bs}
\alias{size.ci.lc.stdmean.bs}
\title{Sample size for a between-subjects standardized linear contrast of means
confidence interval}
\usage{
size.ci.lc.stdmean.bs(alpha, d, w, v)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{d}{planning value of standardized linear contrast of means}

\item{w}{desired confidence interval width}

\item{v}{vector of between-subjects contrast coefficients}
}
\value{
Returns the required sample size per group for each standardizer
}
\description{
Computes the sample size per group (assuming equal sample sizes)
required to estimate two types of standardized linear contrasts of
population means (unweighted average standardizer and single group
standardizer) with desired confidence interval precision in a
between-subjects design. Set the standardized linear contrast of
means to the largest value within a plausible range for a conservatively
large sample size.

For more details, see Section 3.24 of Bonett (2021, Volume 1)
}
\examples{
v <- c(.5, .5, -1)
size.ci.lc.stdmean.bs(.05, .8, .6, v)

# Should return:
#                            Sample size per group
# Unweighted standardizer:                      69
# Single group standardizer:                    78
 

}
\references{
\insertRef{Bonett2009}{statpsych}

\insertRef{Bonett2021}{statpsych}
}
