% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stgam-package.R
\docType{package}
\name{stgam-package}
\alias{stgam}
\alias{stgam-package}
\title{stgam: Spatially and Temporally Varying Coefficient Models Using Generalized Additive Models}
\description{
A framework for undertaking space and time varying coefficient models (varying parameter models) using a Generalized Additive Model (GAM) with smooths approach. The framework suggests the need to investigate for the presence and nature of any space-time dependencies in the data. It proposes a workflow that creates and refines an initial space-time GAM and includes tools to create and evaluate multiple model forms. The workflow sequence is to: i) Prepare the data by lengthening it to have a single location and time variables for each observation. ii) Create all possible space and/or time models in which each predictor is specified in different ways in smooths. iii) Evaluate each model via their AIC value and pick the best one. iv) Create the final model. v) Calculate the varying coefficient estimates to quantify how the relationships between the target and predictor variables vary over space, time or space-time. vi) Create maps, time series plots etc. The number of knots used in each smooth can be specified directly or iteratively increased. This is illustrated with a climate point dataset of the dry rain forest in South America. This builds on work in Comber et al (2024) \doi{10.1080/13658816.2023.2270285} and Comber et al (2004) \doi{10.3390/ijgi13120459}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/lexcomber/stgam}
  \item Report bugs at \url{https://github.com/lexcomber/stgam/issues}
}

}
\author{
\strong{Maintainer}: Lex Comber \email{a.comber@leeds.ac.uk}

Other contributors:
\itemize{
  \item Paul Harris \email{paul.harris@rothamsted.ac.uk} [contributor]
  \item Gonzalo Irisarri \email{jirisarr@uwyo.edu} [contributor]
  \item Chris Brunsdon \email{christopher.brunsdon@mu.ie} [contributor]
}

}
\keyword{internal}
