% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serialization.R
\name{loadScalarJson}
\alias{loadScalarJson}
\title{Load Scalar from JSON}
\usage{
loadScalarJson(json_object, json_scalar_label, subfolder_name = NULL)
}
\arguments{
\item{json_object}{Object of class \code{CppJson}}

\item{json_scalar_label}{Label referring to a particular scalar / string value (i.e. "num_samples") in the overall json hierarchy}

\item{subfolder_name}{(Optional) Name of the subfolder / hierarchy under which vector sits}
}
\value{
R vector
}
\description{
Load a scalar from json

This function is intended for advanced use cases in which users require detailed control of sampling algorithms and data structures.
Minimal input validation and error checks are performed -- users are responsible for providing the correct inputs.
For tutorials on the "proper" usage of the stochtree's advanced workflow, we provide several vignettes at stochtree.ai
}
\examples{
example_scalar <- 5.4
example_json <- createCppJson()
example_json$add_scalar("myscalar", example_scalar)
roundtrip_scalar <- loadScalarJson(example_json, "myscalar")
}
