% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{evaluate_survdnn}
\alias{evaluate_survdnn}
\title{Evaluate a survdnn Model Using Survival Metrics}
\usage{
evaluate_survdnn(
  model,
  metrics = c("cindex", "brier", "ibs"),
  times,
  newdata = NULL,
  na_action = c("omit", "fail"),
  verbose = FALSE
)
}
\arguments{
\item{model}{A fitted `survdnn` model object.}

\item{metrics}{A character vector of metric names: `"cindex"`, `"brier"`, `"ibs"`.}

\item{times}{A numeric vector of evaluation time points.}

\item{newdata}{Optional. A data frame on which to evaluate the model. Defaults to training data.}

\item{na_action}{Character. How to handle missing values in evaluation data:
`"omit"` drops incomplete rows; `"fail"` errors if any NA is present.}

\item{verbose}{Logical. If TRUE and `na_action="omit"`, prints a message when rows are removed.}
}
\value{
A tibble with evaluation results, containing at least `metric`, `value`, and possibly `time`.
}
\description{
Computes evaluation metrics for a fitted `survdnn` model at one or more time points.
Supported metrics include the concordance index (`"cindex"`), Brier score (`"brier"`),
and integrated Brier score (`"ibs"`).
}
