% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing-blacklisthighmap-utils.R
\name{retrievechrom}
\alias{retrievechrom}
\title{Retrieve chromosome lengths and information for a specified genome.}
\usage{
retrievechrom(genomename, verbose, filterchrom = TRUE)
}
\arguments{
\item{genomename}{A character string specifying the UCSC genome name (e.g.,
"hg19" or "mm10").}

\item{verbose}{A logical value. If `TRUE`, the function will print messages
during execution, including a list of the chromosomes being kept.}

\item{filterchrom}{A logical value. If `TRUE`, mitochondrial and non-canonical
chromosomes are removed. Default is \code{TRUE}.}
}
\value{
A `Seqinfo` object containing the names and lengths of the main
  chromosomes for the specified genome.
}
\description{
This function connects to the UCSC Genome Browser database using the
`rtracklayer` package to retrieve chromosome information. It returns a
`Seqinfo` object, filtering out unwanted chromosomes such as mitochondrial
DNA (`chrM`) and those with alternative contigs (indicated by an underscore
`_`).
}
\examples{
# This example requires an internet connection to the UCSC database
hg19_chroms <- retrievechrom(genomename = "hg19", verbose = TRUE)
hg19_chroms

}
