% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop_diff.R
\name{prop_diff}
\alias{prop_diff}
\alias{estimate_proportion_diff}
\alias{s_proportion_diff}
\alias{a_proportion_diff}
\title{Proportion difference estimation}
\usage{
estimate_proportion_diff(
  lyt,
  vars,
  variables = list(strata = NULL),
  conf_level = 0.95,
  method = c("waldcc", "wald", "cmh", "cmh_sato", "cmh_mn", "ha", "newcombe",
    "newcombecc", "strat_newcombe", "strat_newcombecc"),
  weights_method = "cmh",
  var_labels = vars,
  na_str = default_na_str(),
  nested = TRUE,
  show_labels = "hidden",
  table_names = vars,
  section_div = NA_character_,
  ...,
  na_rm = TRUE,
  .stats = c("diff", "diff_ci"),
  .stat_names = NULL,
  .formats = c(diff = "xx.x", diff_ci = "(xx.x, xx.x)"),
  .labels = NULL,
  .indent_mods = c(diff = 0L, diff_ci = 1L)
)

s_proportion_diff(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  variables = list(strata = NULL),
  conf_level = 0.95,
  method = c("waldcc", "wald", "cmh", "cmh_sato", "cmh_mn", "ha", "newcombe",
    "newcombecc", "strat_newcombe", "strat_newcombecc"),
  weights_method = "cmh",
  ...
)

a_proportion_diff(
  df,
  ...,
  .stats = NULL,
  .stat_names = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{lyt}{(\code{PreDataTableLayouts})\cr layout that analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{method}{(\code{string})\cr the method used for the confidence interval estimation.}

\item{weights_method}{(\code{string})\cr weights method. Can be either \code{"cmh"} or \code{"heuristic"}
and directs the way weights are estimated.}

\item{var_labels}{(\code{character})\cr variable labels.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}

\item{nested}{(\code{flag})\cr whether this layout instruction should be applied within the existing layout structure _if
possible (\code{TRUE}, the default) or as a new top-level element (\code{FALSE}). Ignored if it would nest a split.
underneath analyses, which is not allowed.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{table_names}{(\code{character})\cr this can be customized in the case that the same \code{vars} are analyzed multiple
times, to avoid warnings from \code{rtables}.}

\item{section_div}{(\code{string})\cr string which should be repeated as a section divider after each group
defined by this split instruction, or \code{NA_character_} (the default) for no section divider.}

\item{...}{additional arguments for the lower level functions.}

\item{na_rm}{(\code{flag})\cr whether \code{NA} values should be removed from \code{x} prior to analysis.}

\item{.stats}{(\code{character})\cr statistics to select for the table.

Options are: \verb{'diff', 'diff_ci'}}

\item{.stat_names}{(\code{character})\cr names of the statistics that are passed directly to name single statistics
(\code{.stats}). This option is visible when producing \code{\link[rtables:data.frame_export]{rtables::as_result_df()}} with \code{make_ard = TRUE}.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{"auto"} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{.in_ref_col}{(\code{flag})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}
}
\value{
\itemize{
\item \code{estimate_proportion_diff()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_proportion_diff()} to the table layout.
}

\itemize{
\item \code{s_proportion_diff()} returns a named list of elements \code{diff} and \code{diff_ci}.
}

\itemize{
\item \code{a_proportion_diff()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The analysis function \code{\link[=estimate_proportion_diff]{estimate_proportion_diff()}} creates a layout element to estimate the difference in proportion
of responders within a studied population. The primary analysis variable, \code{vars}, is a logical variable indicating
whether a response has occurred for each record. See the \code{method} parameter for options of methods to use when
constructing the confidence interval of the proportion difference. A stratification variable can be supplied via the
\code{strata} element of the \code{variables} argument.
}
\details{
The possible methods are:
\itemize{
\item \code{"waldcc"}: Wald confidence interval with continuity correction \insertCite{Agresti1998}{tern}.
\item \code{"wald"}: Wald confidence interval without continuity correction \insertCite{Agresti1998}{tern}.
\item \code{"cmh"}: Cochran-Mantel-Haenszel (CMH) confidence interval \insertCite{MantelHaenszel1959}{tern}.
\item \code{"cmh_sato"}: CMH confidence interval with Sato variance estimator \insertCite{Sato1989}{tern}.
\item \code{"cmh_mn"}: CMH confidence interval with Miettinen and Nurminen confidence interval
\insertCite{MiettinenNurminen1985}{tern}.
\item \code{"ha"}: Anderson-Hauck confidence interval \insertCite{HauckAnderson1986}{tern}.
\item \code{"newcombe"}: Newcombe confidence interval without continuity correction \insertCite{Newcombe1998}{tern}.
\item \code{"newcombecc"}: Newcombe confidence interval with continuity correction \insertCite{Newcombe1998}{tern}.
\item \code{"strat_newcombe"}: Stratified Newcombe confidence interval without continuity
correction \insertCite{Yan2010-jt}{tern}.
\item \code{"strat_newcombecc"}: Stratified Newcombe confidence interval with continuity
correction \insertCite{Yan2010-jt}{tern}.
}
}
\section{Functions}{
\itemize{
\item \code{estimate_proportion_diff()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

\item \code{s_proportion_diff()}: Statistics function estimating the difference
in terms of responder proportion.

\item \code{a_proportion_diff()}: Formatted analysis function which is used as \code{afun} in \code{estimate_proportion_diff()}.

}}
\note{
When performing an unstratified analysis, methods \code{"cmh"}, \code{"cmh_sato"}, \code{"strat_newcombe"},
and \code{"strat_newcombecc"} are not permitted.
}
\examples{
## "Mid" case: 4/4 respond in group A, 1/2 respond in group B.
nex <- 100 # Number of example rows
dta <- data.frame(
  "rsp" = sample(c(TRUE, FALSE), nex, TRUE),
  "grp" = sample(c("A", "B"), nex, TRUE),
  "f1" = sample(c("a1", "a2"), nex, TRUE),
  "f2" = sample(c("x", "y", "z"), nex, TRUE),
  stringsAsFactors = TRUE
)

l <- basic_table() \%>\%
  split_cols_by(var = "grp", ref_group = "B") \%>\%
  estimate_proportion_diff(
    vars = "rsp",
    conf_level = 0.90,
    method = "ha"
  )

build_table(l, df = dta)

s_proportion_diff(
  df = subset(dta, grp == "A"),
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  conf_level = 0.90,
  method = "ha"
)

# CMH example with strata
s_proportion_diff(
  df = subset(dta, grp == "A"),
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  variables = list(strata = c("f1", "f2")),
  conf_level = 0.90,
  method = "cmh"
)

a_proportion_diff(
  df = subset(dta, grp == "A"),
  .stats = c("diff"),
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  conf_level = 0.90,
  method = "ha"
)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[=d_proportion_diff]{d_proportion_diff()}}
}
