% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporter-junit.R
\name{JunitReporter}
\alias{JunitReporter}
\title{Report results in jUnit XML format}
\description{
This reporter includes detailed results about each test and summaries,
written to a file (or stdout) in jUnit XML format. This can be read by
the Jenkins Continuous Integration System to report on a dashboard etc.
Requires the \emph{xml2} package.

To fit into the jUnit structure, \code{context()} becomes the \verb{<testsuite>}
name as well as the base of the \verb{<testcase> classname}. The
\code{test_that()} name becomes the rest of the \verb{<testcase> classname}.
The deparsed \code{expect_that()} call becomes the \verb{<testcase>} name.
On failure, the message goes into the \verb{<failure>} node message
argument (first line only) and into its text content (full message).
Execution time and some other details are also recorded.

References for the jUnit XML format:
\url{https://github.com/testmoapp/junitxml}
}
\seealso{
Other reporters: 
\code{\link{CheckReporter}},
\code{\link{DebugReporter}},
\code{\link{FailReporter}},
\code{\link{ListReporter}},
\code{\link{LlmReporter}},
\code{\link{LocationReporter}},
\code{\link{MinimalReporter}},
\code{\link{MultiReporter}},
\code{\link{ProgressReporter}},
\code{\link{RStudioReporter}},
\code{\link{Reporter}},
\code{\link{SilentReporter}},
\code{\link{SlowReporter}},
\code{\link{StopReporter}},
\code{\link{SummaryReporter}},
\code{\link{TapReporter}},
\code{\link{TeamcityReporter}}
}
\concept{reporters}
