% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtm.R
\name{create_dtm}
\alias{create_dtm}
\alias{create_dtm.itoken}
\alias{create_dtm.itoken_parallel}
\title{Document-term matrix construction}
\usage{
create_dtm(it, vectorizer, type = c("dgCMatrix", "dgTMatrix",
  "dgRMatrix", "CsparseMatrix", "TsparseMatrix", "RsparseMatrix"), ...)

\method{create_dtm}{itoken}(it, vectorizer, type = c("dgCMatrix",
  "dgTMatrix", "dgRMatrix", "CsparseMatrix", "TsparseMatrix",
  "RsparseMatrix"), ...)

\method{create_dtm}{itoken_parallel}(it, vectorizer,
  type = c("dgCMatrix", "dgTMatrix", "dgRMatrix", "CsparseMatrix",
  "TsparseMatrix", "RsparseMatrix"), ...)
}
\arguments{
\item{it}{\link{itoken} iterator or \code{list} of \code{itoken} iterators.}

\item{vectorizer}{\code{function} vectorizer function; see
\link{vectorizers}.}

\item{type}{\code{character}, one of \code{c("CsparseMatrix", "TsparseMatrix")}.}

\item{...}{placeholder for additional arguments (not used at the moment).
over \code{it}.}
}
\value{
A document-term matrix
}
\description{
This is a high-level function for creating a document-term
  matrix.
}
\details{
If a parallel backend is registered and first argument is a list of \code{itoken},
iterators, function will construct the DTM in multiple threads.
User should keep in mind that he or she should split the data itself and provide a list of
\link{itoken} iterators. Each element of \code{it} will be handled in separate
thread and combined at the end of processing.
}
\examples{
\dontrun{
data("movie_review")
N = 1000
it = itoken(movie_review$review[1:N], preprocess_function = tolower,
             tokenizer = word_tokenizer)
v = create_vocabulary(it)
#remove very common and uncommon words
pruned_vocab = prune_vocabulary(v, term_count_min = 10,
 doc_proportion_max = 0.5, doc_proportion_min = 0.001)
vectorizer = vocab_vectorizer(v)
it = itoken(movie_review$review[1:N], preprocess_function = tolower,
             tokenizer = word_tokenizer)
dtm = create_dtm(it, vectorizer)
# get tf-idf matrix from bag-of-words matrix
dtm_tfidf = transformer_tfidf(dtm)

## Example of parallel mode
it = token_parallel(movie_review$review[1:N], tolower, word_tokenizer, movie_review$id[1:N])
vectorizer = hash_vectorizer()
dtm = create_dtm(it, vectorizer, type = 'TsparseMatrix')
}
}
\seealso{
\link{itoken} \link{vectorizers}
}
