% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_long_short_returns.R
\name{compute_long_short_returns}
\alias{compute_long_short_returns}
\title{Compute Long-Short Returns}
\usage{
compute_long_short_returns(
  data,
  direction = "top_minus_bottom",
  data_options = NULL
)
}
\arguments{
\item{data}{A data frame containing portfolio returns. The data frame must include
columns for the portfolio identifier, date, and return measurements. The portfolio column should
indicate different portfolios, and there should be columns for return measurements prefixed with
"ret_excess".}

\item{direction}{A character string specifying the direction of the long-short return calculation.
It can be either "top_minus_bottom" or "bottom_minus_top". Default is "top_minus_bottom". If set
to "bottom_minus_top", the return will be computed as (bottom - top).}

\item{data_options}{A named list of \link{data_options} with characters, indicating the column
names required to run this function. The required column names identify dates. Defaults to
\code{date = date}, \code{portfolio = portfolio} and \code{ret_excess = ret_excess}.}
}
\value{
A data frame with columns for date, return measurement types (from the "ret_measure"
column), and the computed long-short returns. The data frame is arranged by date and pivoted to
have return measurement types as columns with their corresponding long-short returns.
}
\description{
This function calculates long-short returns based on the returns of portfolios. The long-short
return is computed as the difference between the returns of the "top" and "bottom" portfolios.
The direction of the calculation can be adjusted based on whether the return from the "bottom"
portfolio is subtracted from or added to the return from the "top" portfolio.
}
\examples{
data <- data.frame(
  permno = 1:100,
  date = rep(seq.Date(from = as.Date("2020-01-01"), by = "month", length.out = 100), each = 10),
  mktcap_lag = runif(100, 100, 1000),
  ret_excess = rnorm(100),
  size = runif(100, 50, 150)
)

portfolio_returns <- compute_portfolio_returns(
  data, "size", "univariate",
  breakpoint_options_main = breakpoint_options(n_portfolios = 5)
)

compute_long_short_returns(portfolio_returns)

}
