% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_laslog.R
\name{read_laslog}
\alias{read_laslog}
\title{Read a LAS well log file (Log ASCII Standard) into a structured object}
\usage{
read_laslog(file, output = c("long", "wide"))
}
\arguments{
\item{file}{Path to a .las file}

\item{output}{Output format:
\describe{
\item{"wide"}{One row per depth per well, curves as columns (ML- and spreadsheet-ready).}
\item{"long"}{One row per curve measurement with columns depth, mnemonic, and value (tidy format).}
}}
}
\value{
An S3 object of class "laslog" with VERSION/WELL/CURVE/PARAMETER/OTHER/LOG
}
\description{
tidylaslog supports two equivalent representations of LAS log data:
}
\details{
\itemize{
\item \strong{Wide format}: one row per depth step per well, with each curve stored as a separate column.
\item \strong{Long format}: one row per measurement, with curve names stored in a \code{mnemonic} column and values in a \code{value} column.
}

Both formats contain the same information but are optimized for different workflows.
}
\examples{
las_text <- c(
  " ~Version Information",
  " VERS. 2.0: CWLS LOG ASCII STANDARD",
  " WRAP. NO:",
  " ~Well Information",
  " STRT.M 1000: Start depth",
  " STOP.M 1002: Stop depth",
  " STEP.M 1: Step",
  " NULL. -999.25: Null value",
  " API . 1111111111: API number",
  " CNTY. TEST: County",
  " ~Curve Information",
  " DEPT.M: Depth",
  " GR.API: Gamma Ray",
  " ~ASCII Log Data",
  " 1000 80",
  " 1001 82",
  " 1002 79"
)
f <- tempfile(fileext = ".las")
writeLines(las_text, f)
x <- read_laslog(f, output = "long")
head(x$LOG)
}
