% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logical.R
\name{logical-functions}
\alias{logical-functions}
\alias{any}
\alias{all}
\title{NA-aware Logical Functions}
\usage{
any(x, na.rm = TRUE, all_na = NULL, ...)

all(x, na.rm = TRUE, all_na = NULL, ...)
}
\arguments{
\item{x}{A logical vector.}

\item{na.rm}{Logical. Should missing values be removed? Default \code{TRUE}.}

\item{all_na}{Character. What to do when all values are NA:
\code{"error"} (default) throws an error, \code{"base"} returns what base R does
with \code{na.rm = TRUE} (\code{FALSE} for \code{any()}, \code{TRUE} for \code{all()}),
\code{"na"} returns \code{NA}. If \code{NULL}, uses \code{getOption("tidyna.all_na", "error")}.}

\item{...}{Additional arguments passed to the base function.}
}
\value{
A single logical value.
}
\description{
Drop-in replacements for \code{any()} and \code{all()} that default to \code{na.rm = TRUE}.
}
\examples{
x <- c(TRUE, NA, FALSE)
any(x)
all(x)

}
