% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/construct_recipes.R
\name{construct_recipes}
\alias{construct_recipes}
\title{Construct a sequence of model recipes for sequential synthesis}
\usage{
construct_recipes(
  roadmap,
  default_regression_steps = NULL,
  default_classification_steps = NULL,
  custom_steps = NULL
)
}
\arguments{
\item{roadmap}{A roadmap object}

\item{default_regression_steps}{A list containing one or more recipes::step_*()}

\item{default_classification_steps}{A list containing one or more recipes::step_*()}

\item{custom_steps}{A list of lists containing one or more recipes::step_*()}
}
\value{
A list of formulas
}
\description{
Construct a sequence of model recipes for sequential synthesis
}
\examples{

rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
)

construct_recipes(rm)


# construct_recipes() can create a sequence of recipes using a fully-default 
# approach, a hybrid approach, or a fully-customized approach. All approaches
# require a roadmap and steps. 

rm <- roadmap(
  conf_data = acs_conf_nw,
  start_data = acs_start_nw
)

step1 <- function(x) {
x |>
  recipes::step_center(recipes::all_predictors(), id = "center")
}

# Fully-default approach

construct_recipes(
  roadmap = rm, 
  default_regression_steps = step1, 
  default_classification_steps = step1
)

# Hybrid approach

step2 <- function(x) {
  x |>
    recipes::step_scale(recipes::all_predictors(), id = "scale")
}

construct_recipes(
  roadmap = rm, 
  default_regression_steps = step1,
  default_classification_steps = step1,
  custom_steps = list(
    list(vars = "age", step = step2)
  )
)

# Fully-customized approach

construct_recipes(
  roadmap = rm, 
  custom_steps = list(
    list(vars = c("hcovany", "empstat", "classwkr"), step = step1),
    list(vars = c("age", "famsize", "transit_time", "inctot"), step = step1)
  )
)

}
