% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-spat-contour.R,
%   R/geom-spat-contour-text.R, R/geom-spat-contour-fill.R
\name{geom_spat_contour}
\alias{geom_spat_contour}
\alias{geom_spatraster_contour}
\alias{geom_spatraster_contour_text}
\alias{geom_spatraster_contour_filled}
\title{Plot \code{SpatRaster} contours}
\usage{
geom_spatraster_contour(
  mapping = NULL,
  data,
  ...,
  maxcell = 5e+05,
  bins = NULL,
  binwidth = NULL,
  breaks = NULL,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  mask_projection = FALSE
)

geom_spatraster_contour_text(
  mapping = NULL,
  data,
  ...,
  maxcell = 5e+05,
  bins = NULL,
  binwidth = NULL,
  breaks = NULL,
  size.unit = "mm",
  label_format = scales::label_number(),
  label_placer = isoband::label_placer_minmax(),
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  mask_projection = FALSE
)

geom_spatraster_contour_filled(
  mapping = NULL,
  data,
  ...,
  maxcell = 5e+05,
  bins = NULL,
  binwidth = NULL,
  breaks = NULL,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE,
  mask_projection = FALSE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}. See
\strong{Aesthetics} specially in the use of \code{fill} aesthetic.}

\item{data}{A \code{SpatRaster} object.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{maxcell}{positive integer. Maximum number of cells to use for
the plot.}

\item{bins}{Number of contour bins. Overridden by \code{breaks}.}

\item{binwidth}{The width of the contour bins. Overridden by \code{bins}.}

\item{breaks}{One of:
\itemize{
\item Numeric vector to set the contour breaks
\item A function that takes the range of the data and binwidth as input
and returns breaks as output. A function can be created from a formula
(e.g. ~ fullseq(.x, .y)).
}

Overrides \code{binwidth} and \code{bins}. By default, this is a vector of length
ten with \code{\link[=pretty]{pretty()}} breaks.}

\item{na.rm}{If \code{TRUE}, the default, missing values are silently removed. If
\code{FALSE}, missing values are removed with a warning.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display. To include legend keys for all levels, even
when no data exists, use \code{TRUE}.  If \code{NA}, all levels are shown in legend,
but unobserved levels are omitted.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them.}

\item{mask_projection}{logical, defaults to \code{FALSE}. If \code{TRUE}, mask out
areas outside the input extent. For example, to avoid data wrapping
around the date-line in Equal Area projections. This argument is passed
to \code{\link[terra:project]{terra::project()}} when reprojecting the \code{SpatRaster}.}

\item{size.unit}{How the \code{size} aesthetic is interpreted: as millimetres
(\code{"mm"}, default), points (\code{"pt"}), centimetres (\code{"cm"}), inches (\code{"in"}),
or picas (\code{"pc"}).}

\item{label_format}{One of:
\itemize{
\item \code{NULL} for no labels. This produced the same result than
\code{geom_spatraster_contour()}.
\item A character vector giving labels (must be same length as the breaks
produced by \code{bins}, \code{binwidth}, or \code{breaks}).
\item A function that takes the breaks as input and returns labels as output,
as the default setup (\code{\link[scales:label_number]{scales::label_number()}}).
}}

\item{label_placer}{Function that controls how labels are placed along
the isolines. Uses \code{\link[isoband:label_placer_minmax]{label_placer_minmax()}} by default.}
}
\value{
A \CRANpkg{ggplot2} layer
}
\description{
These geoms create contours of \code{SpatRaster} objects.  To specify a valid
surface, you should specify the layer on \code{aes(z = layer_name)}, otherwise all
the layers would be consider for creating contours. See also \strong{Facets}
section.

The underlying implementation is based on \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.

\code{geom_spatraster_contour_text()} creates labeled contours and it is
implemented on top of \code{\link[isoband:isolines_grob]{isoband::isolines_grob()}}.
}
\section{\CRANpkg{terra} equivalent}{


\code{\link[terra:contour]{terra::contour()}}
}

\section{Aesthetics}{


\code{geom_spatraster_contour()} / \code{geom_spatraster_contour_text()} understands
the following aesthetics:
\itemize{
\item \code{\link[ggplot2:aes_colour_fill_alpha]{alpha}}
\item \code{\link[ggplot2:aes_colour_fill_alpha]{colour}}
\item \code{\link[ggplot2:aes_group_order]{group}}
\item \code{\link[ggplot2:aes_linetype_size_shape]{linetype}}
\item \code{\link[ggplot2:aes_linetype_size_shape]{linewidth}}
\code{geom_spatraster_contour_text()} understands also:
\item \code{\link[ggplot2:aes_linetype_size_shape]{size}}
\item \code{label}
\item \code{family}
\item \code{fontface}
}

Additionally, \code{geom_spatraster_contour_filled()} understands also the
following aesthetics, as well as the ones listed above:
\itemize{
\item \code{\link[ggplot2:aes_colour_fill_alpha]{fill}}
\item \code{subgroup}
}

Check \code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}} for more info on contours and
\code{vignette("ggplot2-specs", package = "ggplot2")} for an overview of the
aesthetics.
}

\section{Computed variables}{


These geom computes internally some variables that are available for use as
aesthetics, using (for example) \verb{aes(color = after_stat(<computed>))} (see
\code{\link[ggplot2:aes_eval]{ggplot2::after_stat()}}).
\itemize{
\item \code{after_stat(lyr)}: Name of the layer.
\item \code{after_stat(level)}: Height of contour. For contour lines, this is numeric
vector that represents bin boundaries. For contour bands, this is an
ordered factor that represents bin ranges.
\item \code{after_stat(nlevel)}: Height of contour, scaled to maximum of 1.
\item \code{after_stat(level_low)}, \code{after_stat(level_high)},
\code{after_stat(level_mid)}: (contour bands only) Lower and upper bin
boundaries for each band, as well the mid point between the boundaries.
}
}

\section{Dropped variables}{

\itemize{
\item \code{z}: After contouring, the \code{z} values of individual data points are no
longer available.
}
}

\section{Coords}{


When the \code{SpatRaster} does not present a crs (i.e.,
\code{terra::crs(rast) == ""}) the geom does not make any assumption on the
scales.

On \code{SpatRaster} that have a crs, the geom uses \code{\link[ggplot2:ggsf]{ggplot2::coord_sf()}} to
adjust the scales. That means that also the
\strong{\code{SpatRaster} may be reprojected}.
}

\section{Facets}{


You can use \code{ facet_wrap(~lyr)} for creating a faceted plot by each layer of
the \code{SpatRaster} object. See \code{\link[ggplot2:facet_wrap]{ggplot2::facet_wrap()}} for details.
}

\examples{
\donttest{

library(terra)

# Raster
f <- system.file("extdata/volcano2.tif", package = "tidyterra")
r <- rast(f)

library(ggplot2)

ggplot() +
  geom_spatraster_contour(data = r)


# Labelled
ggplot() +
  geom_spatraster_contour_text(
    data = r, breaks = c(110, 130, 160, 190),
    color = "grey10", family = "serif"
  )


ggplot() +
  geom_spatraster_contour(
    data = r, aes(color = after_stat(level)),
    binwidth = 1,
    linewidth = 0.4
  ) +
  scale_color_gradientn(
    colours = hcl.colors(20, "Inferno"),
    guide = guide_coloursteps()
  ) +
  theme_minimal()

# Filled with breaks
ggplot() +
  geom_spatraster_contour_filled(data = r, breaks = seq(80, 200, 10)) +
  scale_fill_hypso_d()

# Both lines and contours
ggplot() +
  geom_spatraster_contour_filled(
    data = r, breaks = seq(80, 200, 10),
    alpha = .7
  ) +
  geom_spatraster_contour(
    data = r, breaks = seq(80, 200, 2.5),
    color = "grey30",
    linewidth = 0.1
  ) +
  scale_fill_hypso_d()
}

}
\seealso{
\code{\link[ggplot2:geom_contour]{ggplot2::geom_contour()}}.

The \CRANpkg{metR} package also provides a set of alternative functions:
\itemize{
\item \code{metR::geom_contour2()}.
\item \code{metR::geom_text_contour()} and \code{metR::geom_label_contour()}.
\item \code{metR::geom_contour_tanaka()}.
}

Other \CRANpkg{ggplot2} utils:
\code{\link{autoplot.Spat}},
\code{\link{fortify.Spat}},
\code{\link{geom_spatraster}()},
\code{\link{geom_spatraster_rgb}()},
\code{\link{ggspatvector}},
\code{\link{stat_spat_coordinates}()}
}
\concept{ggplot2.utils}
