% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidytlg-package.R
\docType{package}
\name{tidytlg}
\alias{tidytlg-package}
\alias{tidytlg}
\title{\code{tidytlg}: A package for producing tables, listings,
and graphs (\code{TLGs}) using \code{tidyverse} packages.}
\description{
The \code{tidytlg} package provide a set of function allowing you to produce TLGs
using table metadata.
}
\section{\code{tidytlg} Options}{


\itemize{ \item{\code{tidytlg.row_type.levels} - The values of row_type and their
respective levels. Default: c("TABLE_BY_HEADER", "BY_HEADER1", "BY_HEADER2",
"BY_HEADER3", "BY_HEADER4", "BY_HEADER5", "HEADER", "N", "VALUE", "NESTED")}
\item{\code{tidytlg.fontsize.title} - Font size for titles in points. Default: 10}
\item{\code{tidytlg.fontsize.table.footnote} - Font size for footnotes in points.
For tables. Default: 9} \item{\code{tidytlg.fontsize.listing.footnote} - Font size
for footnotes in points. For listings. Default: 8}
\item{\code{tidytlg.fontsize.graph.footnote} - Font size for footnotes in points.
For graphs. Default: 8} \item{\code{tidytlg.fontsize.table} - Font size for tables
in points. Default: 9} \item{\code{tidytlg.fontsize.graph} - Font size for graphs in
points. Default: 10} \item{\code{tidytlg.fontsize.listing} - Font size for listings
in points. Default: 8} \item{\code{tidytlg.right.padding} - Amount of right padding
for cells in points. Default: 1} \item{\code{tidytlg.left.padding} - Amount of left
padding for cells in points. Default: 1}
\item{\code{tidytlg.stat_labels} - Labels
to be used for each summary statistic in the output table.  Will need to have
all available statistics if this option is changed!}
\item{\code{tidytlg.precision.extra} - Value to be added on for each summary
statistic when calculating precision.  This will be used to make different
statistics have different precision as needed}
\item{\code{tidytlg.nested_freq.statlist.default} - Default \code{statlist} object for
nested_freq tables. Default: \code{statlist("n (x.x)")}}
\item{\code{tidytlg.univar.statlist.default} - Default \code{statlist} object
for \code{univar} tables.
Default: \code{statlist(c("N", "MEANSD", "MEDIAN", "RANGE", "IQRANGE"))}}
\item{\code{tidytlg.freq.statlist.default} - Default \code{statlist} object
for frequency tables. Default: \code{statlist("n (x.x)")}}
\item{\code{tidytlg.stat_labels} - A \code{data.frame} controlling how the stats
are labeled in a \code{univar} table. See 'Default Stat Labels' section
for defaults.}
\item{\code{tidytlg.denoms.message} - A \code{boolean}, should a message print
detailing what the denominators are?}
}
}

\section{Default Stat Labels}{
\tabular{ll}{
   \strong{stat} \tab \strong{label} \cr
   \code{N} \tab N \cr
   \code{SUM} \tab Sum \cr
   \code{MEAN} \tab Mean \cr
   \code{GeoMEAN} \tab Geometric Mean \cr
   \code{SD} \tab Std. Deviation \cr
   \code{SE} \tab Std. Error \cr
   \code{GSD} \tab Geometric Std. Deviation \cr
   \code{GSE} \tab Geometric Std. Error \cr
   \code{CV} \tab CV \cr
   \code{MEANSD} \tab Mean (SD) \cr
   \code{MEANSE} \tab Mean (SE) \cr
   \code{MEDIAN} \tab Median \cr
   \code{MIN} \tab Minimum \cr
   \code{MAX} \tab Maximum \cr
   \code{RANGE} \tab Range \cr
   \code{Q1} \tab First quartile \cr
   \code{Q3} \tab Third quartile \cr
   \code{IQRANGE} \tab IQ range \cr
   \code{MEDRANGE} \tab Median (Range) \cr
   \code{MEDIQRANGE} \tab Median (Q1; Q3) \cr
   \code{MEAN_CI} \tab Mean (95\% C.I.) \cr
   \code{GeoMEAN_CI} \tab Geometric Mean (95\% C.I.) \cr
}
}

\section{Default Precision Extra}{
\tabular{ll}{
   \strong{stat} \tab \strong{extra} \cr
   \code{N} \tab 0 \cr
   \code{SUM} \tab 0 \cr
   \code{MEAN} \tab 1 \cr
   \code{GeoMEAN} \tab 1 \cr
   \code{SD} \tab 2 \cr
   \code{SE} \tab 2 \cr
   \code{GSD} \tab 2 \cr
   \code{GSE} \tab 2 \cr
   \code{CV} \tab 1 \cr
   \code{MEDIAN} \tab 1 \cr
   \code{MIN} \tab 0 \cr
   \code{MAX} \tab 0 \cr
   \code{Q1} \tab 1 \cr
   \code{Q3} \tab 1 \cr
   \code{LCL_MEAN} \tab 2 \cr
   \code{UCL_MEAN} \tab 2 \cr
   \code{LCL_GeoMEAN} \tab 2 \cr
   \code{UCL_GeoMEAN} \tab 2 \cr
}
}

\section{Updating Options}{

\itemize{
\item{For a single session, an option can be changed by
\verb{option(<optionToChange> = <NewValue>)}}
\item{To change an option for a single projects across sessions in that
projects, place the options update in the \code{.Rprofile} in that project
directory.}
\item{To change an option for a user across all sessions, place the options
update in the \code{.Rprofile} file in the users home directory.}
\item{To change an option for all users in an R environment, place the
options update in the \code{.Rprofile.site} file in the R home directory.}
}
}

\seealso{
Useful links:
\itemize{
  \item \url{https://pharmaverse.github.io/tidytlg/main/}
  \item \url{https://github.com/pharmaverse/tidytlg}
  \item Report bugs at \url{https://github.com/pharmaverse/tidytlg/issues}
}

}
\author{
\strong{Maintainer}: Konrad Pagacz \email{kpagacz@its.jnj.com}

Authors:
\itemize{
  \item Nicholas Masel \email{nmasel@its.jnj.com}
  \item Steven Haesendonckx \email{shaesen2@its.jnj.com}
  \item Pelagia Alexandra Papadopoulou \email{ppapadop@its.jnj.com}
  \item Sheng-Wei Wang \email{swang69@its.jnj.com}
  \item Eli Miller \email{eli.miller@atorusresearch.com} (\href{https://orcid.org/0000-0002-2127-9456}{ORCID})
  \item Nathan Kosiba \email{nkosiba@its.jnj.com} (\href{https://orcid.org/0000-0001-5359-4234}{ORCID})
  \item Aidan Ceney \email{aceney@its.jnj.com} (\href{https://orcid.org/0000-0001-8313-487X}{ORCID})
}

Other contributors:
\itemize{
  \item Janssen R&D [copyright holder, funder]
  \item David Hugh-Jones (Author of included 'huxtable' library) [copyright holder]
}

}
\keyword{internal}
