% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_interval.R
\name{time_interval}
\alias{time_interval}
\alias{is_time_interval}
\alias{new_time_interval}
\alias{interval_start}
\alias{interval_end}
\alias{interval_width}
\alias{interval_count}
\alias{interval_range}
\title{S3-based Time Intervals (Currently very experimental and so subject to change)}
\usage{
time_interval(start = integer(), width = resolution(start))

is_time_interval(x)

new_time_interval(start, width)

interval_start(x)

interval_end(x)

interval_width(x)

interval_count(x)

interval_range(x)
}
\arguments{
\item{start}{Start time. \cr
E.g a \code{Date}, \code{POSIXt}, \code{numeric} and more.}

\item{width}{Interval width supplied as a \link{timespan}.
By default this is the \link{resolution} of a time vector so for example,
a date's resolution is exactly 1 day, therefore
\code{time_interval(Sys.Date())} simply represents today's date
as an interval.}

\item{x}{A \link{time_interval}.}
}
\value{
An object of class \code{time_interval}. \cr
\code{is_time_interval} returns a logical of length 1. \cr
\code{interval_start} returns the start times. \cr
\code{interval_end} returns the end times. \cr
\code{interval_width} returns the width of the interval as a \link{timespan}. \cr
\code{interval_count} returns a data frame of unique intervals and their counts. \cr
\code{interval_range} returns a the range of the interval. \cr
\code{new_time_interval} is a bare-bones version of \code{time_interval()} that
performs no checks.
}
\description{
Inspired by both 'lubridate' and 'ivs',
\code{time_interval} objects are lightweight S3 objects of a fixed width.
This enables fast and flexible representation of time data
such as months, weeks, and more.
They are all left closed, right open intervals.
}
\details{
Currently because of limitations with the S3/S4 system,
one can't use time intervals directly with lubridate periods.
To navigate around this, \code{timeplyr::timespan()} can be used.
e.g. instead of \code{interval / weeks(3)}, use \code{interval / timespan(weeks(3))}
or even \code{interval / "3 weeks"}. where \code{interval} is a \code{time_interval}.

To perform interval algebra it is advised to use the 'ivs' package.
To convert a \code{time_interval} into an \code{ivs_iv}, use
\code{ivs::iv(interval_start(x), interval_end(x))}.
}
\examples{
library(dplyr)
library(timeplyr)
library(lubridate)
x <- 1:10
int <- time_interval(x, 100)
int

month_start <- floor_date(today(), unit = "months")
month_int <- time_interval(month_start, "month")
month_int

interval_start(month_int)
interval_end(month_int)

# Divide an interval into different time units
time_interval(today(), years(10)) / timespan("year")

# Cutting Sepal Length into blocks of width 1
int <- time_cut_width(iris$Sepal.Length, 1)
interval_count(int)

}
\seealso{
\link{interval_start}
}
