% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.R
\name{compare_sequences}
\alias{compare_sequences}
\alias{compare_sequences.default}
\alias{compare_sequences.group_tna}
\title{Compare Sequences Between Groups}
\usage{
compare_sequences(x, ...)

\method{compare_sequences}{default}(x, group, sub, min_freq = 5L, correction = "bonferroni", ...)

\method{compare_sequences}{group_tna}(x, sub, min_freq = 5L, correction = "bonferroni", ...)
}
\arguments{
\item{x}{A \code{group_tna} object or a \code{data.frame} containing sequence data in
wide format.}

\item{...}{Not used.}

\item{group}{A \code{vector} indicating the group assignment of each
row of the data/sequence. Must have the same length as the number of
rows/sequences of \code{x}. Alternatively, a single \code{character} string giving
the column name of the data that defines the group when \code{x} is a wide
format \code{data.frame} or a \code{tna_data} object.}

\item{sub}{An \code{integer} vector of subsequence lengths to analyze.
The default is \code{2:5}.}

\item{min_freq}{An \code{integer} giving the minimum number of times that a
specific pattern has to be observed to be included in the analysis.
The default is \code{5}.}

\item{correction}{A \code{character} string naming the multiple comparison
correction method (default: \code{"bonferroni"}). Supports all
\link[stats:p.adjust]{stats::p.adjust} methods: \code{"holm"}, \code{"hochberg"}, \code{"hommel"},
\code{"bonferroni"}, \code{"BH"}, \code{"BY"}, \code{"fdr"}, \code{"none"}.}
}
\value{
A \code{tna_sequence_comparison} object, which is a \code{data.frame} with
columns giving the names of the pattern, pattern frequencies, pattern
proportions (within patterns of the same length), test statistic values
and p-values of the tests.
}
\description{
Performs comprehensive sequence comparison analysis between groups. All
patterns of the sequences (subsequences of specific length) are extracted
from all sequences in each group. For two groups, the proportions of the
patterns between the groups are compared with a z-test for proportions.
For more than two groups, the Chi-squared  test is applied. Both tests are
applied within patterns of the same length.
}
\examples{
group <- c(rep("High", 1000), rep("Low", 1000))
comp <- compare_sequences(group_regulation, group)

}
\seealso{
Model comparison functions
\code{\link{compare}()},
\code{\link{compare.group_tna}()},
\code{\link{plot.tna_comparison}()},
\code{\link{plot.tna_sequence_comparison}()},
\code{\link{plot_compare}()},
\code{\link{plot_compare.group_tna}()},
\code{\link{print.tna_comparison}()},
\code{\link{print.tna_sequence_comparison}()}
}
\concept{comparison}
