% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_r_profile_settings.R
\name{set_rprofile_settings}
\alias{set_rprofile_settings}
\title{Configure R Profile Settings for Better User Experience}
\usage{
set_rprofile_settings(set_for_session = TRUE, backup = TRUE)
}
\arguments{
\item{set_for_session}{Logical, defaults to \code{TRUE}. If \code{TRUE}, also applies
these settings to the current R session.}

\item{backup}{Logical, defaults to \code{TRUE}. If \code{TRUE}, creates a backup of
existing \code{.Rprofile} before modifying it.}
}
\value{
Invisible \code{NULL}. Called for side effects.
}
\description{
Configures important settings in your \code{.Rprofile} to improve the R
experience, especially for new users. This includes:
\itemize{
\item Setting package installation to use binaries (non-Linux systems)
\item Increasing the timeout for downloads to prevent installation failures
}

These settings help avoid common issues like source compilation failures
on Windows and timeout errors when downloading large packages.

You can examine your \code{.Rprofile} to confirm changes with
\code{usethis::edit_r_profile()}
}
\examples{
\dontrun{
  # Apply settings to .Rprofile and current session
  set_rprofile_settings()
  
  # Only modify .Rprofile, don't change current session
  set_rprofile_settings(set_for_session = FALSE)
  
  # Modify without creating backup
  set_rprofile_settings(backup = FALSE)
}

}
