% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tt_cell.R
\name{tt_cell}
\alias{tt_cell}
\title{Style specific cells}
\usage{
tt_cell(
  table,
  row,
  column,
  bold = NULL,
  italic = NULL,
  color = NULL,
  fill = NULL,
  align = NULL,
  font_size = NULL,
  rotate = NULL,
  inset = NULL,
  stroke = NULL,
  colspan = 1,
  rowspan = 1,
  content = NULL
)
}
\arguments{
\item{table}{A \code{typst_table} object.}

\item{row}{Row number (1-indexed for data rows, 0 for header). Use negative
indices to target \code{tt_header_above()} rows: -1 is the innermost header_above
(closest to the main header), -2 is the next row up, etc. The column is
normalized to the start of the header group it falls within.}

\item{column}{Column specification: integer index or column name.}

\item{bold}{Logical. Make text bold.}

\item{italic}{Logical. Make text italic.}

\item{color}{Text color.}

\item{fill}{Fill color.}

\item{align}{Cell alignment.}

\item{font_size}{Font size.}

\item{rotate}{Rotation angle (e.g., \code{"90deg"}, \code{90}, \code{"1.5rad"}).}

\item{inset}{Cell padding (e.g., \code{"10pt"}, \code{"5pt 8pt"}).}

\item{stroke}{Stroke (border) specification for the cell. Can be \code{TRUE} for
default 1pt black, a color, a Typst stroke spec like \code{"2pt + blue"}, or a
Typst dictionary like \code{"(bottom: 1pt)"}.}

\item{colspan}{Number of columns to span (default 1).}

\item{rowspan}{Number of rows to span (default 1).}

\item{content}{Optional content to replace cell value.}
}
\value{
The modified \code{typst_table} object.
}
\description{
Applies formatting to individual cells. Allows for precise control over
cell appearance including spanning multiple rows or columns.
}
\examples{
# Highlight a specific cell
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_cell(1, 1, fill = "yellow", bold = TRUE)

# Cell spanning multiple columns
tt(mtcars[1:5, 1:3], rownames = FALSE) |>
  tt_cell(1, 1, colspan = 2, content = "Combined")

}
