% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vapour-gdal-library.R
\name{vapour_set_config}
\alias{vapour_set_config}
\alias{vapour_get_config}
\title{Set and query GDAL configuration options}
\usage{
vapour_set_config(option, value)

vapour_get_config(option)
}
\arguments{
\item{option}{GDAL config name (see Details), character string}

\item{value}{value for config option, character string}
}
\value{
character string for \code{vapour_get_config}, integer 1 for successful \code{vapour_set_config()}
}
\description{
These functions can get and set configuration options for GDAL, for fine
control over specific GDAL behaviours.
}
\details{
Configuration options may also be set as environment variables.

See \href{https://gdal.org/en/stable/user/configoptions.html}{GDAL config options} for
details on available options.
}
\examples{
\dontrun{
(orig <- vapour_get_config("GDAL_CACHEMAX"))
vapour_set_config("GDAL_CACHEMAX", "64")
vapour_get_config("GDAL_CACHEMAX")
vapour_set_config("GDAL_CACHEMAX", orig)
}
}
