% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_variables.R
\name{mask_variables}
\alias{mask_variables}
\title{Mask categorical variables with random labels in a data frame}
\usage{
mask_variables(data, ..., .across_variables = FALSE)
}
\arguments{
\item{data}{a data frame}

\item{...}{Columns to mask using tidyselect semantics. Each can be:
\itemize{
\item Bare column names (e.g., \code{var1, var2})
\item A tidyselect expression (e.g., \code{starts_with("treat_")})
\item A character vector of column names (e.g., \code{c("var1", "var2")})
\item Multiple sets can be provided as separate arguments
}
Only character and factor columns will be processed.}

\item{.across_variables}{logical. If \code{TRUE}, all selected variables will
use the same set of masked labels. If \code{FALSE} (default), each variable
gets its own independent set of masked labels using the column name as
prefix.}
}
\value{
A data frame with the specified categorical columns masked.
Only character and factor columns can be processed.
}
\description{
Applies masked labels to multiple categorical variables in a data frame using
the \code{mask_labels()} function. Each variable gets independent random
masked labels by default, or can optionally use the same masked labels
across all selected variables.
}
\examples{

# Create example data
df <- data.frame(
  treatment = c("control", "intervention", "control"),
  outcome = c("success", "failure", "success"),
  score = c(1, 2, 3)  # numeric, won't be masked
)

set.seed(123)
# Independent masking for each variable (default - uses column names as
# prefixes)
# Using bare names
mask_variables(df, treatment, outcome)
# Or using character vector
mask_variables(df, c("treatment", "outcome"))

set.seed(456)
# Shared masking across variables
mask_variables(df, c("treatment", "outcome"), .across_variables = TRUE)

# Using tidyselect helpers
mask_variables(df, where(is.character))

# Example with multiple categorical columns
df2 <- data.frame(
  group = c("A", "B", "A", "B"),
  condition = c("ctrl", "test", "ctrl", "test")
)
set.seed(123)
result <- mask_variables(df2, c("group", "condition"))
print(result)

# Example with williams dataset (multiple categorical columns)
data(williams)
set.seed(456)
# Using bare names (recommended for interactive use)
williams_masked <- mask_variables(williams, subject, ecology)
head(williams_masked[c("subject", "ecology")])

}
\seealso{
\code{\link{mask_labels}} for masking a single vector,
\code{\link{mask_names}} for masking variable names.
}
\keyword{mask}
