% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Debugger.R
\name{Debugger}
\alias{Debugger}
\title{Debugger.R}
\description{
Debugger.R

Debugger.R
}
\details{
Class for managing the library debugging. Tracks the debugged method
execution times and prints out the full debugging information only when
the main debugging instance is stopped.
}
\examples{

# Creates a debugger instance.

debugger <- Debugger$new()

# Opening and closing debugs in multileveled function calls.

function1 <- function() {
  debugger$open_debug("function1")
  function2()
  debuger$close_debug()
}

function2 <- function() {
  debugger$open_debug("function2")
  Sys.sleep(1)
  debugger$close_debug()
}

# This will produce the following printout to the console after the
# function1 finishes
#
# - 'function1' (execution time 7 ms)
#   - 'function2' (execution time 5 ms)

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{stack}}{local property for storing debugging labels and start times}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Debugger-new}{\code{Debugger$new()}}
\item \href{#method-Debugger-open_debug}{\code{Debugger$open_debug()}}
\item \href{#method-Debugger-add_debug}{\code{Debugger$add_debug()}}
\item \href{#method-Debugger-close_debug}{\code{Debugger$close_debug()}}
\item \href{#method-Debugger-print_debug_tree}{\code{Debugger$print_debug_tree()}}
\item \href{#method-Debugger-clone}{\code{Debugger$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Debugger-new"></a>}}
\if{latex}{\out{\hypertarget{method-Debugger-new}{}}}
\subsection{Method \code{new()}}{
Constructor for initializing the Debugger instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Debugger$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Debugger-open_debug"></a>}}
\if{latex}{\out{\hypertarget{method-Debugger-open_debug}{}}}
\subsection{Method \code{open_debug()}}{
Method for opening new debug instance to the current debugging stack.
Stores also the start time for execution time calculation.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Debugger$open_debug(label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{debugging message}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Debugger-add_debug"></a>}}
\if{latex}{\out{\hypertarget{method-Debugger-add_debug}{}}}
\subsection{Method \code{add_debug()}}{
Method for adding a new debug string under the currently open
debug instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Debugger$add_debug(label)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{debugging message}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Debugger-close_debug"></a>}}
\if{latex}{\out{\hypertarget{method-Debugger-close_debug}{}}}
\subsection{Method \code{close_debug()}}{
Method for closing a debug instance from the current debugging
stack. If the stopped debug instance is the main level one, the
whole debug data is printed out to console. If the stopped debug
instance is not the main level one, calculates the execution time
of current debug instance and updates the stack data.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Debugger$close_debug()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Debugger-print_debug_tree"></a>}}
\if{latex}{\out{\hypertarget{method-Debugger-print_debug_tree}{}}}
\subsection{Method \code{print_debug_tree()}}{
Recursive method for printing out the current debug stack items and
recursively all the item children. This method is called for the whole
stack once the topmost debug instance is stopped.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Debugger$print_debug_tree(entry, depth = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entry}}{current debug level being processed for printing}

\item{\code{depth}}{current processing depth for printing indentation}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Debugger-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Debugger-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Debugger$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
