% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_layer_functions.R
\name{get_roads_layer}
\alias{get_roads_layer}
\title{Retrieve WDNR's roads spatial layer}
\usage{
get_roads_layer(
  county = NULL,
  watershed_code = NULL,
  watershed_name = NULL,
  sf_object = NULL,
  where = NULL,
  layer_type = "all",
  ...
)
}
\arguments{
\item{county}{A character object specifying a county name}

\item{watershed_code}{A character object specifying the HUC code for a
watershed}

\item{watershed_name}{A character object specifying the HUC name for a
watershed}

\item{sf_object}{Any sf polygon object}

\item{where}{SQL statement}

\item{layer_type}{"major_roads" or "minor_roads"}

\item{...}{Additional parameters to pass to
\code{\link[arcpullr]{get_spatial_layer}}}
}
\value{
A sf object of class polylines
}
\description{
A function to retrieve WDNR's roads spatial layers. "layer_type" can be set
to "major_roads" or "minor_roads" to query the Major Roads or County and
Local Roads respectively.
A spatial query can be performed to limit the output of the function by
supplying a county name, watershed code, watershed name, or custom sf polygon
object. Use the 'watershed_lookup' to find valid watershed codes and names.
The "where" argument can be used to run custom SQL queries.
}
\examples{
\dontrun{
get_roads_layer(county = "washington", layer_type = "major_roads")
get_roads_layer(watershed_code = "07070006", layer_type = "minor_roads")
get_roads_layer(where ="HWY_NUM = '43'",layer_type = "major_roads")
}
}
