% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_kde.R
\name{dist_kde}
\alias{dist_kde}
\title{Create distributional object based on a kernel density estimate}
\usage{
dist_kde(
  y,
  h = NULL,
  H = NULL,
  method = c("normal", "robust", "plugin", "lookout"),
  ...
)
}
\arguments{
\item{y}{Numerical vector or matrix of data, or a list of such objects. If a
list is provided, then all objects should be of the same dimension. e.g.,
all vectors, or all matrices with the same number of columns.}

\item{h}{Bandwidth for univariate distribution. Ignored if \code{y} has 2 or more
columns. If \code{NULL}, the \code{\link{kde_bandwidth}} function is used.}

\item{H}{Bandwidth matrix for multivariate distribution. If \code{NULL},
the \code{\link{kde_bandwidth}} function is used.}

\item{method}{The method of bandwidth estimation to use. See \code{\link[=kde_bandwidth]{kde_bandwidth()}}
for details. Ignored if \code{h} or \code{H} are specified.}

\item{...}{Other arguments are passed to \code{\link[ks]{kde}}.}
}
\description{
Creates a distributional object using a kernel density estimate with a
Gaussian kernel obtained from the \code{\link[ks]{kde}()} function. The bandwidth
can be specified; otherwise the \code{\link{kde_bandwidth}()} function is used.
The cdf, quantiles and moments are consistent with the kde. Generating
random values from the kde is equivalent to a smoothed bootstrap.
}
\examples{
dist_kde(c(rnorm(200), rnorm(100, 5)))
dist_kde(cbind(rnorm(200), rnorm(200, 5)))

}
\references{
Rob J Hyndman (2026) "That's weird: Anomaly detection using R", Section 2.7 and 3.9,
\url{https://OTexts.com/weird/}.
}
