% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_adms.R
\name{write_adms}
\alias{write_adms}
\title{Export a meteorological data frame in ADMS format}
\usage{
write_adms(x, file = "./ADMS_met.MET", interp = FALSE, max_gap = 2)
}
\arguments{
\item{x}{A data frame imported by \code{\link[=import_ghcn_hourly]{import_ghcn_hourly()}} or
\code{\link[=import_isd_hourly]{import_isd_hourly()}}. Note that this function only works for hourly GHCN
data when \code{abbr_names = TRUE}.}

\item{file}{A file name for the ADMS file. The file is written to the working
directory by default.}

\item{interp}{Should interpolation of missing values be undertaken? If \code{TRUE}
linear interpolation is carried out for gaps of up to and including
\code{max_gap}.}

\item{max_gap}{The maximum gap in hours that should be interpolated where
there are missing data when \code{interp = TRUE.} Data with gaps more than
\code{max_gap} are left as missing.}
}
\value{
\code{write_adms()} returns the input \code{dat} invisibly.
}
\description{
Writes a text file in the ADMS format to a location of the user's choosing,
with optional interpolation of missing values. This function works with data
from both \code{\link[=import_ghcn_hourly]{import_ghcn_hourly()}} and \code{\link[=import_isd_hourly]{import_isd_hourly()}}.
}
\examples{
\dontrun{
# import some data then export it
dat <- import_isd_hourly(year = 2012)
write_adms(dat, file = "~/adms_met.MET")
}
}
\seealso{
Other Met writing functions: 
\code{\link{write_met}()}
}
\concept{ADMS functions}
\concept{Met writing functions}
