% Generated by roxygen2: do not edit by hand
% Please edit documentation in src/process_to_wv.cpp, src/process_to_wv.h
\name{arma11_to_wv}
\alias{arma11_to_wv}
\title{ARMA(1,1) to WV}
\usage{
arma11_to_wv(phi, theta, sigma2, tau)
}
\arguments{
\item{phi}{A \code{double} corresponding to the autoregressive term.}

\item{theta}{A \code{double} corresponding to the moving average term.}

\item{sigma2}{A \code{double} the variance of the process.}

\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{vec} containing the wavelet variance of the ARMA(1,1) process.
}
\description{
This function computes the WV (haar) of an Autoregressive Order 1 - Moving Average Order 1 (ARMA(1,1)) process.
}
\details{
This function is significantly faster than its generalized counter part
\code{\link{arma_to_wv}}
}
\section{Process Haar Wavelet Variance Formula}{

The Autoregressive Order \eqn{1} and Moving Average Order \eqn{1} (ARMA(\eqn{1},\eqn{1})) process has a Haar Wavelet Variance given by:
\deqn{\nu _j^2\left( {\phi ,\theta ,{\sigma ^2}} \right) =  - \frac{{2{\sigma ^2}\left( { - \frac{1}{2}{{(\theta  + 1)}^2}\left( {{\phi ^2} - 1} \right){\tau _j} - (\theta  + \phi )(\theta \phi  + 1)\left( {{\phi ^{{\tau _j}}} - 4{\phi ^{\frac{{{\tau _j}}}{2}}} + 3} \right)} \right)}}{{{{(\phi  - 1)}^3}(\phi  + 1)\tau _j^2}}}{nu[j]^2 (phi, theta, sigma2) = (-2*sigma2*((-(theta + phi))*(1 + theta*phi)*(3 - 4*phi^(tau[j]/2) + phi^tau[j]) - 0.5*(1 + theta)^2*(-1 + phi^2)*tau[j])) / ((-1 + phi)^3*(1 + phi)*tau[j]^2)}
}

\seealso{
\code{\link{arma_to_wv}}
}
