% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/algorithm.R
\name{rand_unit}
\alias{rand_unit}
\title{Pseudo-random numbers on \verb{[0, 1)} based on a linear congruential generator}
\usage{
rand_unit(n = 1, a = 55797, c = 0, m = 4294967296, seed = NULL)
}
\arguments{
\item{n}{The desired length of the sequence.}

\item{a, c, m}{Parameters for the generator (see References for the default
values).}

\item{seed}{The seed. The default is the system time when this function is
called for the first time in the current session. For subsequent calls, the
last \eqn{X_i}{X[i]} of the previous call will be used as the default seed.}
}
\value{
Random numbers on \verb{[0, 1)} (i.e., \eqn{X/m} instead of \eqn{X}). Note
the unit interval is open on the right (excluding 1).
}
\description{
Generate pseudo-random numbers from \eqn{X_{i+1} = (aX_i + c) \bmod{m}}{X\link[=i +
1]{i + 1} = (a * X\link{i} + c) \%\% m}, where \eqn{X_1}{X[1]} is the initial value (seed).
}
\note{
All argument values must be smaller than \eqn{2^{64}}{2^64} as they
will be coerced to 64-bit integers.
}
\examples{
rand_unit(10)
rand_unit(10, seed = 0)
rand_unit(10, seed = 0)  # identical results
rand_unit(10, seed = Sys.getpid())
}
\references{
Steele, Guy L. Jr.; Vigna, Sebastiano (2022). "Computationally
easy, spectrally good multipliers for congruential pseudorandom number
generators". \emph{Software: Practice and Experience.} 52 (2): 443–458.
}
