% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_index.R
\name{g_index}
\alias{g_index}
\title{g_index - Egghe's g-index}
\usage{
g_index(df, id = NULL, cit, plot = FALSE)
}
\arguments{
\item{df}{Data frame object containing bibliometric data. This data frame must
have at least two columns: one for keywords and one for citation counts. An optional
column for unique identifiers can be included. Each row in the data frame should
represent a document or publication.}

\item{id}{Character string specifying the name of the column in "df" that contains
unique identifiers for each document. Each cell in this column must contain a single
ID (unless missing) and not multiple IDs. Must be included when 'plot' parameter is set
to "TRUE". Default set to NULL.}

\item{cit}{Character string specifying the name of the column in "df" that contains
the number of citations each document has received. Citations must be represented
as integers. Each cell in this column should contain a single integer value
(unless missing) representing the citation count for the corresponding document.}

\item{plot}{Logical value indicating whether to generate and display a plot of
the g-index calculation. Set to "TRUE" or "T" to generate the plot, and "FALSE" (default)
or "F" to skip plot generation.}
}
\value{
g-index magnitude and optional plot.
}
\description{
Calculate g-index for an institution using bibliometric data from an edge list,
with an optional visualisation of ranked citation scores.
}
\examples{
# Load example data
data(WoSdata)

# Calculate g-index with plot
g_index(df = WoSdata,
        id = "UT.Unique.WOS.ID",
        cit = "Times.Cited.WoS.Core",
        plot = TRUE)

}
